/* - AccelDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AccelerometerPhidget;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AccelDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numAxesTxt;
    private JTextField accel1Txt;
    private JTextField accel2Txt;
    private JTextField accel3Txt;
    private JTextField sensitivity1Txt;
    private JTextField sensitivity2Txt;
    private JTextField sensitivity3Txt;
    
    /** Creates a new instance of AccelDetachListener */
    public AccelDetachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numAxesTxt,
            JTextField accel1Txt, JTextField accel2Txt, JTextField accel3Txt, 
            JTextField sensitivity1Txt, JTextField sensitivity2Txt, JTextField sensitivity3Txt)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numAxesTxt = numAxesTxt;
        this.accel1Txt = accel1Txt;
        this.accel2Txt = accel2Txt;
        this.accel3Txt = accel3Txt;
        this.sensitivity1Txt = sensitivity1Txt;
        this.sensitivity2Txt = sensitivity2Txt;
        this.sensitivity3Txt = sensitivity3Txt;
    }

    public void detached(DetachEvent de)
    {
        try
         {
            AccelerometerPhidget detached = (AccelerometerPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numAxesTxt.setText("");
            accel1Txt.setText("");
            accel2Txt.setText("");
            accel3Txt.setText("");
            
            sensitivity1Txt.setText("");
            sensitivity2Txt.setText("");
            sensitivity3Txt.setText("");
            sensitivity1Txt.setEnabled(false);
            sensitivity2Txt.setEnabled(false);
            sensitivity3Txt.setEnabled(false);
            
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
